new const NINTENDOMOD_YOSHI_PLUGIN[] = "Nintendo Mod X Yoshi"
new const NINTENDOMOD_YOSHI_VERSION[] = "2.5"
new const NINTENDOMOD_YOSHI_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Green Dino
		* Increased armor at the expense of looking green.
	2nd Passive: Defense Exchange
		* Sometimes you almost do double damage consuming your armor.
	Skill 1: Jump
		* Lower Gravity.
	Skill 2: Speed
		* Increased  Speed.
	Skill 3: Mole
		* Chance of spawning in enemy spawn looking like your enemy.
	PowerUp: Egg Mine
		* Lays an egg that acts as a proximity mine and as a tunnel.

	Based on Soloist's original source code Yoshi v1.1, updated by Mephisto
	Version 2.5
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.5
			* unstuck function improved
			* egg mine ping sound slightly increased
			* added sound when egg mine is thrown
			* different egg mine sounds for CTs and Ts
			* PowerUp ready again if egg mine was stucked
			* remaining egg mines removed on disconnect
		Version 2.4
			* remaining fake egg mine bug fixed
			* CT's egg mines can not be laid too close to the dropped bomb
			* egg mines can be thrown now
			* teleport stuck bug fixed
			* egg mines explode if laid too close to enemies' egg mine
			* egg mine HP reduced
		Version 2.3
			* mole improved, made fair for both, attacker and defenders
			* egg camp protection added
		Version 2.2
			* teleport added (to base / between 2 eggs)
			* real egg's origin fixed (no longer the values of midair are saved if planted in midair)
			* more effects on egg explosion to players (punch, knockback)
			* mole spawn bug (on heads of enemies) fixed
			* egg activation time dependent on PowerUp lvl (in general shorter)
		Version 2.1.2
			* plugin title changed
		Version 2.1.1
			* invalid id error in ResetHUD probably fixed
		Version 2.1
			* hopefully fixed wrong egg explosions
		Version 2.0
			* Yoshi can walk silent now
			* 2 eggs at PowerUp lvl 2
			* eggs will explode if planted near bomb or hostages
			* eggs can be destroyed by shooting on them, but they have much hp
			* eggs glow in team's color
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.1
			* Fixed glow bug
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <cstrike>
#include <hamsandwich>
#include <engine>
#include <fakemeta>
#include <fun>
#include <nintendomod>

#define MAX_SAVE_ITERATIONS	10
#define TASK_RESETSPAWNS	3000
#define TASK_RESETSENSE		4000
#define TASK_SETTELEPORT	5000

new const Float:YOSHI_ARMORNUM[11] = {100.0, 110.0, 120.0, 130.0, 140.0, 150.0, 160.0, 170.0, 180.0, 190.0, 200.0};
new const YOSHI_GREENNUM[11] = {255, 240, 230, 220, 210, 200, 190, 180, 170, 160, 150};
new const YOSHI_EGGDMG[3] = {100, 125, 200};
new const Float:YOSHI_EGGTIMER[3] = {3.0, 2.75, 2.5};
new const Float:YOSHI_EGGPORTDELAY[3] = {10.0, 8.0, 7.0};
new const Float:YOSHI_EGGPORTACT = 1.0;
new const Float:YOSHI_EGGPUNCH = 25.0;
new const Float:YOSHI_EGGHP = 500.0;
new const YOSHI_PORTRADIUS = 12;
new const YOSHI_SHAKENEARBYRAD = 600;
new const Float:YOSHI_CONFUSESENSE = 25.0;
new const Float:YOSHI_CONFUSETIME[4] = {0.2, 0.3, 0.4, 0.5};
new const Float:YOSHI_EXCHANGENUM[5] = {0.3, 0.4, 0.45, 0.5, 0.6};
new const Float:YOSHI_EXCHANGESTR[5] = {0.6, 0.7, 0.75, 0.8, 0.9};
new const Float:YOSHI_EXCHANGEPROB[5] = {0.3, 0.35, 0.4, 0.45, 0.5};
new const Float:YOSHI_ARMORREPAIR[5] = {2.0, 3.0, 4.0, 5.0, 6.0};
new const Float:YOSHI_JUMPGRAV[4] = {700.0, 500.0, 400.0, 350.0};
new const Float:YOSHI_SPEEDNUM[4] = {300.0, 325.0, 350.0, 365.0};
new const Float:YOSHI_MOLEPROB[4] = {0.01, 0.111, 0.155, 0.18};

// these arrays are used for the unstuck function
new const Float:size_z_first[][3] = {
	{0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, 1.0, 0.0}, {-1.0, -1.0, 0.0}, {0.0, 1.0, 1.0}, {0.0, -1.0, 1.0}, {1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {0.0, 1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, 0.0, -1.0}, {-1.0, 0.0, -1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, -1.0, 1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0},
	{0.0, 0.0, 2.0}, {0.0, 0.0, -2.0}, {0.0, 2.0, 0.0}, {0.0, -2.0, 0.0}, {2.0, 0.0, 0.0}, {-2.0, 0.0, 0.0}, {2.0, 2.0, 0.0}, {2.0, -2.0, 0.0}, {-2.0, 2.0, 0.0}, {-2.0, -2.0, 0.0}, {0.0, 2.0, 2.0}, {0.0, -2.0, 2.0}, {2.0, 0.0, 2.0}, {-2.0, 0.0, 2.0}, {0.0, 2.0, -2.0}, {0.0, -2.0, -2.0}, {2.0, 0.0, -2.0}, {-2.0, 0.0, -2.0}, {2.0, 2.0, 2.0}, {2.0, -2.0, 2.0}, {-2.0, 2.0, 2.0}, {-2.0, -2.0, 2.0}, {2.0, 2.0, -2.0}, {2.0, -2.0, -2.0}, {-2.0, 2.0, -2.0}, {-2.0, -2.0, -2.0},
	{0.0, 0.0, 3.0}, {0.0, 0.0, -3.0}, {0.0, 3.0, 0.0}, {0.0, -3.0, 0.0}, {3.0, 0.0, 0.0}, {-3.0, 0.0, 0.0}, {3.0, 3.0, 0.0}, {3.0, -3.0, 0.0}, {-3.0, 3.0, 0.0}, {-3.0, -3.0, 0.0}, {0.0, 3.0, 3.0}, {0.0, -3.0, 3.0}, {3.0, 0.0, 3.0}, {-3.0, 0.0, 3.0}, {0.0, 3.0, -3.0}, {0.0, -3.0, -3.0}, {3.0, 0.0, -3.0}, {-3.0, 0.0, -3.0}, {3.0, 3.0, 3.0}, {3.0, -3.0, 3.0}, {-3.0, 3.0, 3.0}, {-3.0, -3.0, 3.0}, {3.0, 3.0, -3.0}, {3.0, -3.0, -3.0}, {-3.0, 3.0, -3.0}, {-3.0, -3.0, -3.0},
	{0.0, 0.0, 4.0}, {0.0, 0.0, -4.0}, {0.0, 4.0, 0.0}, {0.0, -4.0, 0.0}, {4.0, 0.0, 0.0}, {-4.0, 0.0, 0.0}, {4.0, 4.0, 0.0}, {4.0, -4.0, 0.0}, {-4.0, 4.0, 0.0}, {-4.0, -4.0, 0.0}, {0.0, 4.0, 4.0}, {0.0, -4.0, 4.0}, {4.0, 0.0, 4.0}, {-4.0, 0.0, 4.0}, {0.0, 4.0, -4.0}, {0.0, -4.0, -4.0}, {4.0, 0.0, -4.0}, {-4.0, 0.0, -4.0}, {4.0, 4.0, 4.0}, {4.0, -4.0, 4.0}, {-4.0, 4.0, 4.0}, {-4.0, -4.0, 4.0}, {4.0, 4.0, -4.0}, {4.0, -4.0, -4.0}, {-4.0, 4.0, -4.0}, {-4.0, -4.0, -4.0},
	{0.0, 0.0, 5.0}, {0.0, 0.0, -5.0}, {0.0, 5.0, 0.0}, {0.0, -5.0, 0.0}, {5.0, 0.0, 0.0}, {-5.0, 0.0, 0.0}, {5.0, 5.0, 0.0}, {5.0, -5.0, 0.0}, {-5.0, 5.0, 0.0}, {-5.0, -5.0, 0.0}, {0.0, 5.0, 5.0}, {0.0, -5.0, 5.0}, {5.0, 0.0, 5.0}, {-5.0, 0.0, 5.0}, {0.0, 5.0, -5.0}, {0.0, -5.0, -5.0}, {5.0, 0.0, -5.0}, {-5.0, 0.0, -5.0}, {5.0, 5.0, 5.0}, {5.0, -5.0, 5.0}, {-5.0, 5.0, 5.0}, {-5.0, -5.0, 5.0}, {5.0, 5.0, -5.0}, {5.0, -5.0, -5.0}, {-5.0, 5.0, -5.0}, {-5.0, -5.0, -5.0}
}
new const Float:size_xy_first[][3] = {
	{0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, 1.0, 0.0}, {-1.0, -1.0, 0.0}, {0.0, 1.0, 1.0}, {0.0, -1.0, 1.0}, {1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {0.0, 1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, 0.0, -1.0}, {-1.0, 0.0, -1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, -1.0, 1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0},
	{0.0, 2.0, 0.0}, {0.0, -2.0, 0.0}, {2.0, 0.0, 0.0}, {-2.0, 0.0, 0.0}, {2.0, 2.0, 0.0}, {2.0, -2.0, 0.0}, {-2.0, 2.0, 0.0}, {-2.0, -2.0, 0.0}, {0.0, 2.0, 2.0}, {0.0, -2.0, 2.0}, {2.0, 0.0, 2.0}, {-2.0, 0.0, 2.0}, {0.0, 2.0, -2.0}, {0.0, -2.0, -2.0}, {2.0, 0.0, -2.0}, {-2.0, 0.0, -2.0}, {2.0, 2.0, 2.0}, {2.0, -2.0, 2.0}, {-2.0, 2.0, 2.0}, {-2.0, -2.0, 2.0}, {2.0, 2.0, -2.0}, {2.0, -2.0, -2.0}, {-2.0, 2.0, -2.0}, {-2.0, -2.0, -2.0}, {0.0, 0.0, 2.0}, {0.0, 0.0, -2.0},
	{0.0, 3.0, 0.0}, {0.0, -3.0, 0.0}, {3.0, 0.0, 0.0}, {-3.0, 0.0, 0.0}, {3.0, 3.0, 0.0}, {3.0, -3.0, 0.0}, {-3.0, 3.0, 0.0}, {-3.0, -3.0, 0.0}, {0.0, 3.0, 3.0}, {0.0, -3.0, 3.0}, {3.0, 0.0, 3.0}, {-3.0, 0.0, 3.0}, {0.0, 3.0, -3.0}, {0.0, -3.0, -3.0}, {3.0, 0.0, -3.0}, {-3.0, 0.0, -3.0}, {3.0, 3.0, 3.0}, {3.0, -3.0, 3.0}, {-3.0, 3.0, 3.0}, {-3.0, -3.0, 3.0}, {3.0, 3.0, -3.0}, {3.0, -3.0, -3.0}, {-3.0, 3.0, -3.0}, {-3.0, -3.0, -3.0}, {0.0, 0.0, 3.0}, {0.0, 0.0, -3.0},
	{0.0, 4.0, 0.0}, {0.0, -4.0, 0.0}, {4.0, 0.0, 0.0}, {-4.0, 0.0, 0.0}, {4.0, 4.0, 0.0}, {4.0, -4.0, 0.0}, {-4.0, 4.0, 0.0}, {-4.0, -4.0, 0.0}, {0.0, 4.0, 4.0}, {0.0, -4.0, 4.0}, {4.0, 0.0, 4.0}, {-4.0, 0.0, 4.0}, {0.0, 4.0, -4.0}, {0.0, -4.0, -4.0}, {4.0, 0.0, -4.0}, {-4.0, 0.0, -4.0}, {4.0, 4.0, 4.0}, {4.0, -4.0, 4.0}, {-4.0, 4.0, 4.0}, {-4.0, -4.0, 4.0}, {4.0, 4.0, -4.0}, {4.0, -4.0, -4.0}, {-4.0, 4.0, -4.0}, {-4.0, -4.0, -4.0}, {0.0, 0.0, 4.0}, {0.0, 0.0, -4.0},
	{0.0, 5.0, 0.0}, {0.0, -5.0, 0.0}, {5.0, 0.0, 0.0}, {-5.0, 0.0, 0.0}, {5.0, 5.0, 0.0}, {5.0, -5.0, 0.0}, {-5.0, 5.0, 0.0}, {-5.0, -5.0, 0.0}, {0.0, 5.0, 5.0}, {0.0, -5.0, 5.0}, {5.0, 0.0, 5.0}, {-5.0, 0.0, 5.0}, {0.0, 5.0, -5.0}, {0.0, -5.0, -5.0}, {5.0, 0.0, -5.0}, {-5.0, 0.0, -5.0}, {5.0, 5.0, 5.0}, {5.0, -5.0, 5.0}, {-5.0, 5.0, 5.0}, {-5.0, -5.0, 5.0}, {5.0, 5.0, -5.0}, {5.0, -5.0, -5.0}, {-5.0, 5.0, -5.0}, {-5.0, -5.0, -5.0}, {0.0, 0.0, 5.0}, {0.0, 0.0, -5.0}
}

new charName[] = "Yoshi";
new passiveName[] = "Green Dino";
new passive2Name[] = "Defense Exchange";
new skill1Name[] = "Jump";
new skill2Name[] = "Speed";
new skill3Name[] = "Mole";
new powerupName[] = "Egg Mine";
new initName[] = "Yoshi_Init";
new keyDownName[] = "Yoshi_Egg";

new passiveHelp[] = "Increased armor at the expense of looking green.";
new passive2Help[] = "Sometimes you almost do double damage consuming your armor.";
new skill1Help[] = "Lower Gravity.";
new skill2Help[] = "Increased  Speed.";
new skill3Help[] = "Change of spawning in enemy spawn looking like your enemy.";
new powerupHelp[] = "Lays an egg that acts as a proximity mine and as a tunnel.";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new bool:BetweenRounds;

new bool:mole[33], bool:teleport_ready[33];
new SpawnInc = 0, SpawnReserved[64];
new CTSkins[5][] = {"sas", "gsg9", "urban", "gign", "spetsnaz"}
new TSkins[5][] = {"arctic", "leet", "guerilla", "terror", "militia"}
new spawnEntString[2][] = {"info_player_start", "info_player_deathmatch"}

new laidEggs[33], eggMine[65], mineOrigin[65][3], sprBoom, sprSmoke, sprShock, sprFire;
new Float:oldSense[33];

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_YOSHI_PLUGIN, NINTENDOMOD_YOSHI_VERSION, NINTENDOMOD_YOSHI_AUTHOR);

	register_cvar("NintendoMod_Yoshi_Version", NINTENDOMOD_YOSHI_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");
	register_logevent("RoundStart", 2, "1=Round_Start")
	register_logevent("RoundEnd", 2, "1=Round_End")

//	RegisterHam(Ham_TakeDamage, "info_target", "Yoshi_EggHit");
	register_event("Damage", "Yoshi_Damage", "b", "2!0");
	register_event("CurWeapon", "Yoshi_Speed", "be");
	register_forward(FM_PlayerPreThink, "Yoshi_Walking");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheModel, "models/nintendomod/yoshi_eggmine.mdl");
	engfunc(EngFunc_PrecacheSound, "nintendomod/yoshi_eggping.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/yoshi_eggping2.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/yoshi_eggthrow.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/yoshi_port.wav");

	sprBoom  = engfunc(EngFunc_PrecacheModel, "sprites/zerogxplode.spr");
	sprSmoke = engfunc(EngFunc_PrecacheModel, "sprites/steam1.spr");
	sprShock = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr");
	sprFire  = engfunc(EngFunc_PrecacheModel, "sprites/explode1.spr");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	oldSense[id] = 0.0;

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new ent;
	InitPlayer(id);
	remove_task(id);
	remove_task(id+32);
	eggMine[id] = eggMine[id+32] = 0;
	Yoshi_ResetSense(TASK_RESETSENSE+id);
	while((ent = find_ent_by_owner(-1, "egg_mine", id)))
		engfunc(EngFunc_RemoveEntity, ent);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public Yoshi_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public RoundStart()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = false;
	new ent;
	
	while((ent = find_ent_by_class(-1,"egg_mine")))
		engfunc(EngFunc_RemoveEntity, ent);

	return PLUGIN_CONTINUE;
}

public RoundEnd()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = true;

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_CONTINUE;

	cs_reset_user_model(id);
	Nintendo_SetGlow(id);
	entity_set_int(id, EV_INT_flTimeStepSound, 200);
	Yoshi_ResetSense(TASK_RESETSENSE+id);

	remove_task(id);
	remove_task(id+32);
	remove_task(id+100);

	if(!Nintendo_HasChar(id, charName))
		return PLUGIN_HANDLED;

	mole[id] = false;
	teleport_ready[id] = false;

	set_task(0.1, "Yoshi_Mole", id+100);

	eggMine[id] = eggMine[id+32] = 0;
	laidEggs[id] = 0;

	Yoshi_Jump(id);
	Yoshi_Passive(id);
	set_task(get_cvar_float("mp_freezetime"), "Yoshi_Speed", id);
	set_task(get_cvar_float("mp_freezetime"), "Yoshi_Passive", id);
	if(PlayerLevel[id] > 10)
		set_task(get_cvar_float("mp_freezetime"), "Yoshi_DefenseRepair", id);

	return PLUGIN_CONTINUE;
}

public Yoshi_Damage(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart)
	new headshot = bodypart == 1 ? 1 : 0

	if(Nintendo_HasChar(attacker, charName) && PlayerLevel[attacker] > 10 && Nintendo_IsValidPlayer(attacker))
	{
		new Float:randomnumber = random_float(0.0, 1.0);

		if(Nintendo_TeamKill(id, attacker) && randomnumber <= YOSHI_EXCHANGEPROB[PlayerLevel[attacker] - 11])
		{
			new Float:damage = float(read_data(2)) * YOSHI_EXCHANGESTR[PlayerLevel[attacker] - 11];
			new Float:plrArmor = float(pev(attacker, pev_armorvalue));
			if(plrArmor - damage / YOSHI_EXCHANGENUM[PlayerLevel[attacker] - 11] >= 0.0)
			{
				new Float:newArmor = plrArmor - damage / YOSHI_EXCHANGENUM[PlayerLevel[attacker] - 11];
				Nintendo_SetArmor(attacker, float(floatround(newArmor)));
				Nintendo_ExtraDamage(attacker, id, floatround(damage), "Defense Exchange", headshot);
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Yoshi_Passive(id) // Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerLevel[id] > 10)
	{
		Nintendo_SetArmor(id, YOSHI_ARMORNUM[10]);
		Nintendo_SetGlow(id, kRenderFxGlowShell, 0, YOSHI_GREENNUM[10], 0, kRenderNormal, 25);
	}
	else
	{
		Nintendo_SetArmor(id, YOSHI_ARMORNUM[PlayerLevel[id]]);
		Nintendo_SetGlow(id, kRenderFxGlowShell, 0, YOSHI_GREENNUM[PlayerLevel[id]], 0, kRenderNormal, 25);
	}

	return PLUGIN_CONTINUE;
}

public Yoshi_Jump(id) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName)  || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[id] > 0)
		Nintendo_SetGravity(id, YOSHI_JUMPGRAV[PlayerSkill1[id] - 1]);

	return PLUGIN_CONTINUE;
}

public Yoshi_Speed(id) // Skill 2
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || BetweenRounds)
		return PLUGIN_HANDLED;

	if(PlayerSkill2[id] > 0)
		Nintendo_SetSpeed(id, YOSHI_SPEEDNUM[PlayerSkill2[id] - 1]);

	return PLUGIN_CONTINUE;
}

public Yoshi_DefenseRepair(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || !is_user_alive(id))
		return PLUGIN_HANDLED;

	new Float:plrArmor = float(pev(id, pev_armorvalue)) + YOSHI_ARMORREPAIR[PlayerLevel[id] - 11];
	if(plrArmor > YOSHI_ARMORNUM[10])
		plrArmor = YOSHI_ARMORNUM[10];

	Nintendo_SetArmor(id, plrArmor);
	set_task(3.0, "Yoshi_DefenseRepair", id);

	return PLUGIN_CONTINUE;
}

public Yoshi_Walking(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(oldSense[id] > 0.0)
		Yoshi_SetSense(id);
	
	if(!Nintendo_HasChar(id, charName))
		return PLUGIN_HANDLED;

	// mole between mine eggs (teleport)
	if(PlayerSkill3[id] > 0 && laidEggs[id] == 2 && teleport_ready[id])
	{
		new idOrigin[3], egg_id[2];

		egg_id[0] = id;
		egg_id[1] = id + 32;
		get_user_origin(id, idOrigin);

		for(new i = 0; i < 2; i++)
		{
			if(get_distance(idOrigin, mineOrigin[egg_id[i]]) <= YOSHI_PORTRADIUS)
			{
				// teleport to other egg, but first check if destination is free
				teleport_ready[id] = false;
				
				new Float:unstuck_vec[3];
				unstuck_vec[0] = float(mineOrigin[egg_id[!i]][0]);
				unstuck_vec[1] = float(mineOrigin[egg_id[!i]][1]);
				unstuck_vec[2] = float(mineOrigin[egg_id[!i]][2]);

				if(!Yoshi_Unstuck(id, unstuck_vec, 0))
				{
					Nintendo_StatusHUD(id, "Mole failed! Maybe you have to be ducked!", 1);
					set_task(1.0, "Yoshi_SetTeleport", TASK_SETTELEPORT+id);
					break;
				}
				set_task(YOSHI_EGGPORTDELAY[PlayerPowerUp[id]-1], "Yoshi_SetTeleport", TASK_SETTELEPORT+id);
				engfunc(EngFunc_SetOrigin, id, unstuck_vec);
				Yoshi_ConfusePlayers(id, YOSHI_SHAKENEARBYRAD, false);
				emit_sound(id, CHAN_AUTO, "nintendomod/yoshi_port.wav", 0.2, ATTN_NORM, 0, PITCH_NORM);
			}
		}
	}
	// mole back to base
	else if(PlayerSkill3[id] > 0 && laidEggs[id] == 1 && teleport_ready[id])
	{
		new idOrigin[3];
		new egg_id = (eggMine[id] ? id:id+32);

		get_user_origin(id, idOrigin);
		if(get_distance(idOrigin, mineOrigin[egg_id]) <= YOSHI_PORTRADIUS)
		{
			// teleport to base
			new entSpawn = Yoshi_MoleFindSpawn(get_user_team(id));
			if(entSpawn >= 0)
			{
				new Float:vNewOrigin[3];
				entity_get_vector(entSpawn, EV_VEC_origin, vNewOrigin);
				Nintendo_SetOrigin(id, vNewOrigin);
				Yoshi_ConfusePlayers(id, YOSHI_SHAKENEARBYRAD, false);
				emit_sound(id, CHAN_AUTO, "nintendomod/yoshi_port.wav", 0.2, ATTN_NORM, 0, PITCH_NORM);
				teleport_ready[id] = false;
				set_task(YOSHI_EGGPORTDELAY[PlayerPowerUp[id]-1], "Yoshi_SetTeleport", TASK_SETTELEPORT+id);
			}
		}
	}

	// sneaking
	if(PlayerSkill2[id] < 1)
		return PLUGIN_CONTINUE;

	new Float:vel[3];
	entity_get_vector(id, EV_VEC_velocity, vel);

	// When this is true, the user is walking...  lets hope :P
	if (vector_length(vel) < 200.0)
	{
		entity_set_int(id, EV_INT_flTimeStepSound, 999);
	}

	// Otherwise if we just set it on the previous tick we need to set it back
	else if (entity_get_int(id, EV_INT_flTimeStepSound) > 500)
	{
		entity_set_int(id, EV_INT_flTimeStepSound, 200);
	}

	return PLUGIN_CONTINUE;
}

public Yoshi_Mole(id) // Skill 3
{
	id-=100;
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerSkill3[id] > 0)
	{
		new Float:randomnumber = random_float(0.0, 1.0);
		if(randomnumber <= YOSHI_MOLEPROB[PlayerSkill3[id] - 1])
		{
			new num = 0, newSkin[32]
			num = random_num(0,3)

			if(get_user_team(id) == 1)
				add(newSkin, 31, CTSkins[num]);
			else
				add(newSkin, 31, TSkins[num]);

			cs_set_user_model(id,newSkin);
			mole[id] = true;

			Nintendo_StatusHUD(id, "You are going to be a mole! Be prepared!", 1);
			client_print(id, print_chat, "[Nintendo Mod] You are going to be a mole! Be prepared!");
			set_task(get_cvar_float("mp_freezetime"), "Yoshi_Teleport", id);

			return PLUGIN_HANDLED;
		}

	}

	return PLUGIN_CONTINUE;
}

public Yoshi_FinishMole(id)
{
	mole[id] = false;
}

public Yoshi_Teleport(id)
{
	new Float:vNewOrigin[3];

	new entSpawn;
	if(get_user_team(id) == 2)
		 entSpawn = Yoshi_MoleFindSpawn(1);
	else
		 entSpawn = Yoshi_MoleFindSpawn(2);

	if (entSpawn < 0)
	{
		mole[id] = false;
		return PLUGIN_CONTINUE;
	}

	entity_get_vector(entSpawn, EV_VEC_origin, vNewOrigin);
	Nintendo_SetOrigin(id, vNewOrigin);
	Yoshi_ConfusePlayers(id, 0, true);

	return PLUGIN_CONTINUE;
}

public Yoshi_SetTeleport(id)
{
	id -= TASK_SETTELEPORT;
	teleport_ready[id] = true;

	return PLUGIN_CONTINUE;
}

public Yoshi_ConfusePlayers(id, radius, bool:all)
{
	new players[32], num;
	new iTeam = get_user_team(id);
	new idOrigin[3], vOrigin[3];

	get_user_origin(id, idOrigin);

	get_players(players, num);
	for(new i = 0; i < num; i++)
	{
		if(get_user_team(players[i]) != iTeam && !mole[players[i]])
		{
			new victim, body;
			get_user_aiming(players[i], victim, body);
			get_user_origin(players[i], vOrigin);
			if(get_distance(idOrigin, vOrigin) <= radius || id == victim)
			{
				message_begin(MSG_ONE, get_user_msgid("ScreenShake"), {0,0,0}, players[i]);
				write_short(1<<15);
				write_short(1<<15);
				write_short(1<<15);
				message_end();

				// interrupt aiming
				new Float:velocity[3];
				pev(players[i], pev_velocity, velocity);
				velocity[2] += 225.0;
				set_pev(players[i], pev_velocity, velocity);
				if(!task_exists(TASK_RESETSENSE+players[i]))
				{
					new rand = random_num(2, 4);
					new Float:delay = float(rand)/10.0;
					set_task(delay, "Yoshi_SetSenseTask", players[i]);
					set_task(delay+YOSHI_CONFUSETIME[PlayerSkill3[id]-1], "Yoshi_ResetSense", TASK_RESETSENSE+players[i]);
				}
			}
			else if(all && !task_exists(TASK_RESETSENSE+players[i]))
			{
				new rand = random_num(1, 3);
				new Float:delay = float(rand)/10;
				set_task(delay, "Yoshi_SetSenseTask", players[i]);
				set_task(delay+YOSHI_CONFUSETIME[PlayerSkill3[id]-1], "Yoshi_ResetSense", TASK_RESETSENSE+players[i]);
			}
		}
	}
	// mole is finished
	set_task(2.0, "Yoshi_FinishMole", id);

	return PLUGIN_CONTINUE;
}

public Yoshi_SetSenseTask(id)
{
	query_client_cvar(id, "sensitivity", "cvar_sense");
}

public cvar_sense(id, const cvar[], const value[])
{	
	oldSense[id] = str_to_float(value);
	
	return PLUGIN_CONTINUE;
}

public Yoshi_SetSense(id)
{
	client_cmd(id, "sensitivity %f", YOSHI_CONFUSESENSE)

	return PLUGIN_CONTINUE;
}

public Yoshi_ResetSense(id)
{
	id -= TASK_RESETSENSE;
	
	if(oldSense[id] > 0.0)
		client_cmd(id, "sensitivity %f", oldSense[id])
	oldSense[id] = 0.0;

	return PLUGIN_CONTINUE;
}

// type: 0 = player (z goes first), 1 = egg (xy goes first)
public Yoshi_Unstuck(id, Float:vec[3], type)
{
	new Float:origin[3];
	new Float:mins[3], hull;
	new i;

	origin[0] = vec[0];
	origin[1] = vec[1];
	origin[2] = vec[2];
	hull = pev(id, pev_flags) & FL_DUCKING ? HULL_HEAD : HULL_HUMAN;

	if(!is_hull_vacant(origin, hull, id))
	{
		pev(id, pev_mins, mins);
		if(type == 0)
			for (i=0; i < sizeof size_z_first; i++) {
				vec[0] = origin[0] - mins[0] * size_z_first[i][0];
				vec[1] = origin[1] - mins[1] * size_z_first[i][1];
				vec[2] = origin[2] - mins[2] * size_z_first[i][2];
				if(is_hull_vacant(vec, hull, id))
					// unstucked
					return 1;
			}
		else
			for (i=0; i < sizeof size_xy_first; i++) {
				vec[0] = origin[0] - mins[0] * size_xy_first[i][0];
				vec[1] = origin[1] - mins[1] * size_xy_first[i][1];
				vec[2] = origin[2] - mins[2] * size_xy_first[i][2];
				if(is_hull_vacant(vec, hull, id))
					// unstucked
					return 1;
			}
	}
	else
		// no unstuck neccessary, no change
		return 2;
	
	// unstuck not possible
	return 0;
}

stock bool:is_hull_vacant(const Float:origin[3], hull, id)
{
	static tr;
	new Float:sky_origin[3];
	sky_origin[0] = origin[0];
	sky_origin[1] = origin[1];
	sky_origin[2] = origin[2] + 40.0;
	
	if(point_contents(sky_origin) != CONTENTS_SKY)
	{
		engfunc(EngFunc_TraceHull, origin, origin, 0, hull, id, tr);
		if(!get_tr2(tr, TraceResult:TR_StartSolid) && !get_tr2(tr, TraceResult:TR_AllSolid))
			return true;
	}

	return false;
}

stock Yoshi_MoleFindSpawn(iTeam)
{

	new iPlayersInVicinity, iSpawnID, iEntList[1];
	new ent = -1;
	new Float:fSpawnOrigin[3];
	new Float:fVicinity = 96.0;
	new bool:bFound = false;

	// Need to determine which spawn point to look for based on the user's team
	iSpawnID = ((iTeam == 2) ? 0 : 1);

	// Loop through each ent until we find a spawn entity that we want
	do {
		ent = find_ent_by_class(ent, spawnEntString[iSpawnID]);
		
		// Valid ent found
		if (ent != 0 && !Yoshi_SpawnReserved(ent))
		{
			// reserve spawn
			SpawnReserved[SpawnInc++] = ent;

			entity_get_vector(ent, EV_VEC_origin, fSpawnOrigin);

			// Check to see if there are players in this spawn
			iPlayersInVicinity = find_sphere_class(0, "player", fVicinity, iEntList, 1, fSpawnOrigin);
			
			// We have a free spawn!!
			if (iPlayersInVicinity == 0)
				bFound = true;
		}
	}
	while (ent && !bFound)

	// Reset the spawn points...
	if(!task_exists(TASK_RESETSPAWNS))
		set_task(0.3, "Yoshi_SpawnReset", TASK_RESETSPAWNS);

	// Failed, nothing found
	if (!bFound )
		return -1;
	
	// Otherwise we found something!
	return ent;
}

public Yoshi_SpawnReset()
{	
	SpawnInc = 0;
	for(new i = 0; i < 64; i++)
		SpawnReserved[i] = 0;

	return PLUGIN_CONTINUE;
}

public bool:Yoshi_SpawnReserved(ent)
{
	for(new i = 0; i < SpawnInc; i++)
		if(SpawnReserved[i] == ent)
			return true;

	return false;
}

public Yoshi_Egg(id)
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		if(PlayerPowerUp[id] < 2 && laidEggs[id])
		{
			Nintendo_PowerUpDeny(id, "You already laid an egg");
			return PLUGIN_HANDLED;
		}
		else if(PlayerPowerUp[id] >= 2 && laidEggs[id] >= 2)
		{
			Nintendo_PowerUpDeny(id, "You already laid two eggs");
			return PLUGIN_HANDLED;
		}

		Nintendo_PowerUpUsed(id, 1, 30);
		new idOrigin[3];
		get_user_origin(id, idOrigin);
		Yoshi_EggPlantMine(id, idOrigin)
	}

	return PLUGIN_CONTINUE;
}

public Yoshi_EggPlantMine(id, idOrigin[3])
{
	new Float:velocity[3];
	velocity_by_aim(id, 600, velocity);

	new Float:origin[3];
	origin[0] = float(idOrigin[0]);
	origin[1] = float(idOrigin[1]);
	origin[2] = float(idOrigin[2]);

	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"));
	set_pev(ent, pev_classname, "egg_mine");

	engfunc(EngFunc_SetModel, ent, "models/nintendomod/yoshi_eggmine.mdl");
	engfunc(EngFunc_SetSize, ent, Float:{-4.0,-4.0,-5.0}, Float:{4.0,4.0,5.0})
	engfunc(EngFunc_SetOrigin, ent, origin);
	set_pev(ent, pev_effects, 32);
	set_pev(ent, pev_solid, SOLID_BBOX);
	set_pev(ent, pev_movetype, MOVETYPE_TOSS);
	set_pev(ent, pev_health, YOSHI_EGGHP);
	set_pev(ent, pev_takedamage, 2.0);
	set_pev(ent, pev_owner, id);
	// throw egg mine in aim direction
	set_pev(ent, pev_velocity, velocity);
	emit_sound(ent, CHAN_AUTO, "nintendomod/yoshi_eggthrow.wav", 0.5, ATTN_NORM, 0, PITCH_NORM);
	if(get_user_team(id) == 1)
		Nintendo_SetGlow(ent, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 30);
	else
		Nintendo_SetGlow(ent, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 30);

	new egg_id = (eggMine[id] ? id+32:id);
	eggMine[egg_id] = ent;
	laidEggs[id]++;
	for(new i=0; i<3; i++)
		mineOrigin[egg_id][i] = floatround(origin[i]);

	Nintendo_StatusHUD(id, "You have laid an egg", 1);
	teleport_ready[id] = false;

	set_task(YOSHI_EGGPORTACT-0.2, "Yoshi_EggSaveOrigin", egg_id);
	set_task(YOSHI_EGGPORTACT, "Yoshi_SetTeleport", TASK_SETTELEPORT+id);
	set_task(YOSHI_EGGTIMER[PlayerPowerUp[id]-1], "Yoshi_EggTimer", egg_id);

	return PLUGIN_HANDLED
}

public Yoshi_EggSaveOrigin(egg_id)
{
	static iterations[65] = 0;

	if(eggMine[egg_id] <= 0 || !pev_valid(eggMine[egg_id]))
		return PLUGIN_CONTINUE;

	new id = (egg_id > 32 ? egg_id-32 : egg_id);
	new Float:origin[3], old_origin[3];

	pev(eggMine[egg_id], pev_origin, origin);

	for (new i=0; i<3; i++)
	{
		old_origin[i] = mineOrigin[egg_id][i];
		mineOrigin[egg_id][i] = floatround(origin[i]);
	}

	mineOrigin[egg_id][2] += 36; // to make sure we don't get stucked when teleporting

	if(iterations[egg_id] < MAX_SAVE_ITERATIONS &&
		(mineOrigin[egg_id][0] != old_origin[0] ||
		mineOrigin[egg_id][1] != old_origin[1] ||
		mineOrigin[egg_id][2] != old_origin[2]))
	{
		iterations[egg_id]++;
		set_task(YOSHI_EGGPORTACT-0.2, "Yoshi_EggSaveOrigin", egg_id);
	}
	else
	{
		origin[2] += 36.0;
		new unstuck = Yoshi_Unstuck(id, origin, 1);
		if(!unstuck || iterations[egg_id] >= MAX_SAVE_ITERATIONS)
		{
			iterations[egg_id] = 0;
			Nintendo_StatusHUD(id, "Your egg mine was unhopefully stucked!", 1);
			remove_task(TASK_SETTELEPORT+id);
			remove_task(egg_id);
			if(eggMine[egg_id] > 0 && pev_valid(eggMine[egg_id]))
			{
				engfunc(EngFunc_RemoveEntity, eggMine[egg_id]);
				eggMine[egg_id] = 0;
				laidEggs[id]--;
				if(laidEggs[id] < 0)
					laidEggs[id] = 0;
				// we want to give another chance to lay egg if it was stucked
				Nintendo_PowerUpUsed(id, 1, 2);
			}
		}
		else if(unstuck == 1)
		{
			origin[2] -= 36.0;
			engfunc(EngFunc_SetOrigin, eggMine[egg_id], origin);
			new Float:vel[3] = {0.0, 0.0, 1.0};
			set_pev(eggMine[egg_id], pev_velocity, vel);
			Yoshi_EggSaveOrigin(egg_id);
			return PLUGIN_CONTINUE;
		}
		else
		{
			// final position found
			iterations[egg_id] = 0;
			// check if laid too close to the dropped bomb (only for cts)
			if(get_user_team(id) == 2)
			{
				new bomb = find_ent_by_class(-1, "weapon_c4");
				// CTs aren't allowed to plant egg mines too close to the dropped bomb
				if(bomb && pev(bomb, pev_owner) > get_maxplayers())
				{
					new Float:bomb_origin[3], Float:egg_origin[3];
					pev(bomb, pev_origin, bomb_origin);
					egg_origin[0] = float(mineOrigin[egg_id][0]);
					egg_origin[1] = float(mineOrigin[egg_id][1]);
					egg_origin[2] = float(mineOrigin[egg_id][2]);

					if(get_distance_f(bomb_origin, egg_origin) < 410.0)
					{
						remove_task(egg_id);
						Yoshi_EggExplode(egg_id);
					}
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Yoshi_EggTimer(egg_id)
{
	new id = (egg_id > 32 ? egg_id-32 : egg_id);
	if(eggMine[egg_id] <= 0 || !pev_valid(eggMine[egg_id]))
	{
		laidEggs[id]--;
		if(laidEggs[id] < 0)
			laidEggs[id] = 0;
		Yoshi_ExplosionEffects(egg_id);
		eggMine[egg_id] = 0;

		return PLUGIN_CONTINUE;
	}

	if(BetweenRounds)
	{
		Yoshi_EggExplode(egg_id);
		return PLUGIN_CONTINUE;
	}

	new idOrigin[3];
	new players[32], num;
	get_players(players, num);

	// check players
	for(new i = 0; i < num; i++)
	{
		new player = players[i];
		if(!Nintendo_IsValidPlayer(player, true) || !Nintendo_TeamKill(id, player) || id == player)
			continue;

		get_user_origin(player, idOrigin);
		if(get_distance(idOrigin, mineOrigin[egg_id]) <= 400 && abs(idOrigin[2]-mineOrigin[egg_id][2]) <= 150 || BetweenRounds)
		{
			Yoshi_EggExplode(egg_id);
			return PLUGIN_CONTINUE;
		}
	}

	// check other targets
	new Float:origin[3];
	origin[0] = float(mineOrigin[egg_id][0]);
	origin[1] = float(mineOrigin[egg_id][1]);
	origin[2] = float(mineOrigin[egg_id][2]);
	new i, ownerID, iTeam = get_user_team(id);
	new target_ents[3][] = {"func_bomb_target", "hostage_entity", "func_vip_safetyzone"};
	new ents, entlist[2];
	new bool:opposing_egg = false;

	// if two opposing egg mines are too close to each other
	for(i=1; i<65; i++)
	{
		if(eggMine[i] > 0)
		{
			ownerID = (i > 32 ? i-32 : i);
			if(get_user_team(ownerID) != iTeam && get_distance(mineOrigin[egg_id], mineOrigin[i]) <= 400)
			{
				opposing_egg = true;
				if(laidEggs[id] == 2)
				{
					new other_egg_id = (egg_id > 32 ? egg_id-32 : egg_id+32);
					if(get_distance(mineOrigin[other_egg_id], mineOrigin[i]) <= 400)
					{
						remove_task(other_egg_id);
						Yoshi_EggExplode(other_egg_id);
					}
				}
				remove_task(i);
				Yoshi_EggExplode(i);
			}
		}
	}
	if(opposing_egg)
	{
		Yoshi_EggExplode(egg_id);
		return PLUGIN_CONTINUE;
	}

	// bomb spots, hostages, vip safetyzones
	for(i=0; i<3; i++)
	{
		ents = find_sphere_class(0, target_ents[i], 450.0, entlist, 1, origin);
		if(ents)
		{
			Yoshi_EggExplode(egg_id);
			return PLUGIN_CONTINUE;
		}
	}

	if(iTeam == 2)
		// play CT egg mine sound
		emit_sound(eggMine[egg_id], CHAN_AUTO, "nintendomod/yoshi_eggping.wav", 0.4, ATTN_NORM, 0, PITCH_NORM);
	else if(iTeam == 1)
		// play T egg mine sound
		emit_sound(eggMine[egg_id], CHAN_AUTO, "nintendomod/yoshi_eggping2.wav", 0.4, ATTN_NORM, 0, PITCH_NORM);
	set_task(1.0, "Yoshi_EggTimer", egg_id);

	return PLUGIN_CONTINUE;
}

public Yoshi_EggExplode(egg_id)
{
	if(eggMine[egg_id] <= 0 || !pev_valid(eggMine[egg_id]))
		return PLUGIN_HANDLED;

	new id = (egg_id > 32 ? egg_id-32 : egg_id);
	new idOrigin[3];
	
	if(laidEggs[id] > 1)
		Nintendo_StatusHUD(id, "One of your egg mines detonated", 1);
	else
		Nintendo_StatusHUD(id, "Your egg mine detonated", 1);
	laidEggs[id]--;
	if(laidEggs[id] < 0)
		laidEggs[id] = 0;

	engfunc(EngFunc_RemoveEntity, eggMine[egg_id]);
	eggMine[egg_id] = 0;

	new players[32], num;
	get_players(players, num);
	for(new i = 0; i < num; i++)
	{
		new player = players[i];
		if(!Nintendo_IsValidPlayer(player))
			continue;

		if(Nintendo_TeamKill(id, player))
		{
			get_user_origin(player, idOrigin);
			if(get_distance(idOrigin, mineOrigin[egg_id]) <= 400 && abs(idOrigin[2]-mineOrigin[egg_id][2]) <= 150)
			{
				message_begin(MSG_ONE, get_user_msgid("ScreenShake"), {0,0,0}, player);
				write_short(1<<15);
				write_short(1<<15);
				write_short(1<<15);
				message_end();

				Nintendo_ExtraDamage(id, player, YOSHI_EGGDMG[PlayerPowerUp[id]-1], "Egg Mine", 0);
				Yoshi_EggKnockback(egg_id, player);
			}
		}
	}

	Yoshi_ExplosionEffects(egg_id);

	return PLUGIN_CONTINUE;
}

public Yoshi_EggKnockback(egg_id, victim)
{
	if(!Nintendo_IsValidPlayer(victim, true))
		return PLUGIN_CONTINUE;

	new id = (egg_id > 32 ? egg_id-32 : egg_id);
	new vicOrigin[3];
	new Float:velocity[3], Float:punch[3];

	get_user_origin(victim, vicOrigin);

	velocity[0] = float(vicOrigin[0] - mineOrigin[egg_id][0]) * 2.0;
	velocity[1] = float(vicOrigin[1] - mineOrigin[egg_id][1]) * 2.0;
	velocity[2] = 250.0;

	punch[0] = random_float(150.0, 150.0 + PlayerPowerUp[id]*YOSHI_EGGPUNCH);
	punch[1] = random_float(150.0, 150.0 + PlayerPowerUp[id]*YOSHI_EGGPUNCH);
	punch[2] = random_float(150.0, 150.0 + PlayerPowerUp[id]*YOSHI_EGGPUNCH);

	set_pev(victim, pev_velocity, velocity);
	entity_set_vector(victim , EV_VEC_punchangle , punch);

	return PLUGIN_CONTINUE;
}

public Yoshi_EggHit(ent, inflictor, attacker, Float:damage, damage_type)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(attacker))
		return HAM_IGNORED;

	new class[64];
	pev(ent, pev_classname, class);
	client_print(attacker, print_console, "hook: classname = '%s'", class);
	if(!equal(class, "egg_mine"))
		return HAM_IGNORED;

	new message[64];
	new Float:egg_hp;

	pev(ent, pev_health, egg_hp);
	client_print(attacker, print_console, "going to print hud msg!");
	formatex(message, 63, "%d damage inflicted, %d HP left", floatround(damage), floatround(egg_hp));
	Nintendo_StatusHUD(attacker, message, 4);

	return HAM_HANDLED;
}

public Yoshi_ExplosionEffects(egg_id)
{
	// Start Explosion Effects..
	// Shockwave Effect
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, mineOrigin[egg_id]);
	write_byte(TE_BEAMCYLINDER);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2] + 16);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2] + 1936);
	write_short(sprShock);
	write_byte(0);
	write_byte(0);
	write_byte(2);
	write_byte(20);
	write_byte(0);
	write_byte(188);
	write_byte(220);
	write_byte(255);
	write_byte(255);
	write_byte(0);
	message_end();

	// Explosion Type 1 Effect
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, mineOrigin[egg_id]);
	write_byte(TE_EXPLOSION);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2]);
	write_short(sprFire);
	write_byte(60);
	write_byte(10);
	write_byte(TE_EXPLFLAG_NONE);
	message_end();

	// Explosion Type 2 Effect
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, mineOrigin[egg_id]);
	write_byte(TE_EXPLOSION2);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2]);
	write_byte(188);
	write_byte(10);
	message_end();

	// Outer Explosion Flame
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, mineOrigin[egg_id]);
	write_byte(TE_EXPLOSION);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2]);
	write_short(sprBoom);
	write_byte(50);
	write_byte(15);
	write_byte(TE_EXPLFLAG_NONE);
	message_end();

	// Smoke Effect
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, mineOrigin[egg_id]);
	write_byte(TE_SMOKE);
	write_coord(mineOrigin[egg_id][0]);
	write_coord(mineOrigin[egg_id][1]);
	write_coord(mineOrigin[egg_id][2]);
	write_short(sprSmoke);
	write_byte(60);
	write_byte(10);
	message_end();

	return PLUGIN_CONTINUE;
}